/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public final class XiangcaoDebugLog {
    private static final DateTimeFormatter TS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static volatile Path logPath;

    private XiangcaoDebugLog() {
    }

    private static Path path() {
        Path p = logPath;
        if (p != null) {
            return p;
        }
        Path dir = Path.of(System.getProperty("user.dir", "."), new String[0]).resolve("logs");
        logPath = p = dir.resolve("xiangcaomengjia.log");
        return p;
    }

    public static void log(String msg) {
        try {
            Path p = XiangcaoDebugLog.path();
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
            String line = "[" + TS.format(LocalDateTime.now()) + "] " + msg + System.lineSeparator();
            Files.writeString(p, (CharSequence)line, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

